<?php
// etseo_engine_cache.php
declare(strict_types=1);

function etseo_engine_cache_dir(): string {
    $base = rtrim(getenv('HOME') ?: sys_get_temp_dir(), '/');
    $dir = $base . '/tmp/etseo_engine_cache';
    if (!is_dir($dir)) @mkdir($dir, 0775, true);
    return $dir;
}

function etseo_engine_cache_key(string $url, string $post_type): string {
    return hash('sha256', $post_type . '|' . $url);
}

function etseo_engine_cache_get(string $key, int $ttlSeconds): ?array {
    $file = etseo_engine_cache_dir() . '/' . $key . '.json';
    if (!is_file($file)) return null;
    $age = time() - (int)filemtime($file);
    if ($age > $ttlSeconds) return null;

    $raw = @file_get_contents($file);
    if (!$raw) return null;
    $data = json_decode($raw, true);
    return is_array($data) ? $data : null;
}

function etseo_engine_cache_set(string $key, array $data): void {
    $file = etseo_engine_cache_dir() . '/' . $key . '.json';
    @file_put_contents($file, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
}
